#ifndef PSX_MACHINE_HPP
#define PSX_MACHINE_HPP

#include "PSXInterpreter.hpp"

namespace NeoPSX
{
	/// The interface to all of the emulated devices.
	class PSXMachine
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		PSXMachine();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		~PSXMachine();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Machine Control

		/** Executes a single instruction and updates video, sound, controllers, etc..
		  */
		void Execute();
		/** Resets all of the emualted devices.
		  */
		void Reset();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Executable Loading

		/** Loads an executable file into memory.
		  */
		const bool LoadExecutable(const EFString& fileName);
		/** Returns the R3000 processor context.
		  */
		TR3000Context* GetContext() const;
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		std::auto_ptr< PSXInterpreter > mProcessor; ///< The playstation CPU interpreter.
	};
} // Namespace NeoPSX

#endif // PSX_MACHINE_HPP